InitUserPrefs();
local eggs = 0
local t = Def.ActorFrame {};

t[#t+1] = Def.ActorFrame {
	OnCommand=function(self)
		if not FILEMAN:DoesFileExist("Save/ThemePrefs.ini") then
			Trace("ThemePrefs doesn't exist; creating file")
			ThemePrefs.ForceSave()
		end

		ThemePrefs.Save()
	end;
};

t[#t+1] = Def.BitmapText { 
	Font= "Common Normal",
	Text=SONGMAN:GetNumSongs() .. " songs in " .. SONGMAN:GetNumSongGroups() .. " groups",
	InitCommand=function(self) 
		self:shadowlength(1):zoom(0.5):xy(16,16):diffuse(color("#AED3CE")):horizalign(left) 
	end;			
	OnCommand=function(self)
		self:diffusealpha(0):smooth(0.4):diffusealpha(1)
	end;
	OffCommand=function(self) self:smooth(0.4):diffusealpha(0) end;
};

t[#t+1] = Def.BitmapText { 
	Font= "Common Normal",
	Text=SONGMAN:GetNumCourses() .. " courses",
	InitCommand=function(self) 
		self:shadowlength(1):zoom(0.5):xy(16,32):diffuse(color("#AED3CE")):horizalign(left) 
	end;			
	OnCommand=function(self)
		self:diffusealpha(0):smooth(0.4):diffusealpha(1)
	end;
	OffCommand=function(self) self:smooth(0.4):diffusealpha(0) end;
};
	
t[#t+1] = Def.BitmapText { 
	Font= "Common Normal",
	Text= string.format("StepMania %s", ProductVersion()), 
	InitCommand=function(self) 
		self:shadowlength(1):zoom(0.75):x(SCREEN_RIGHT-16):y(16)
		self:diffuse(color("#AED3CE")):horizalign(right) 
	end;
	OnCommand=function(self)
		self:diffusealpha(0):smooth(0.4):diffusealpha(1)
	end;
	OffCommand=function(self) self:smooth(0.4):diffusealpha(0) end;
};

t[#t+1] = Def.BitmapText { 
	Font= "Common Normal",
	Text= VersionDate(),
	InitCommand=function(self) 
		self:shadowlength(1):zoom(0.4):x(SCREEN_RIGHT-16):y(30)
		self:diffuse(color("#AED3CE")):horizalign(right) 
	end;
	OnCommand=function(self)
		self:diffusealpha(0):smooth(0.4):diffusealpha(1)
	end;
	OffCommand=function(self) self:smooth(0.4):diffusealpha(0) end;
};

t[#t+1] = Def.BitmapText { 
	Font= "Common Normal",
	Text= "Theme version v1.0.1",
	InitCommand=function(self) 
		self:horizalign(center):zoom(0.6):shadowlength(1):x(SCREEN_CENTER_X):y(SCREEN_BOTTOM-14):diffuse(color("#AED3CE"))
	end;
	OnCommand=function(self)
		self:diffusealpha(0):smooth(0.4):diffusealpha(1)
	end;
	OffCommand=function(self) self:smooth(0.4):diffusealpha(0) end;
};

return t;